"use strict";

var _util = _interopRequireDefault(require("util"));

var _through = _interopRequireDefault(require("through2"));

var _terser = _interopRequireDefault(require("terser"));

var _pluginError = _interopRequireDefault(require("plugin-error"));

var _vinylSourcemapsApply = _interopRequireDefault(require("vinyl-sourcemaps-apply"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var PLUGIN_NAME = 'terser';

/* promise兼容 */
function isPromise() {
  var _util$types;

  if (_util.default === null || _util.default === void 0 ? void 0 : (_util$types = _util.default.types) === null || _util$types === void 0 ? void 0 : _util$types.isPromise) {
    return _util.default.types.isPromise;
  } else {
    return require('is-promise').default;
  }
}
/**
 * @param { Object } defaultOption: gulp传递的配置
 * @param { Function, undefined } minify: 自定义的压缩函数
 * @return { Function }
 */


function gulpTerser() {
  var defaultOption = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var minify = arguments.length > 1 ? arguments[1] : undefined;
  // source-map option
  defaultOption.sourceMap = (defaultOption === null || defaultOption === void 0 ? void 0 : defaultOption.sourceMap) || {};

  var stream = _through.default.obj(function (file, enc, callback) {
    var _this = this;

    if (file.isStream()) {
      this.emit('error', new _pluginError.default(PLUGIN_NAME, 'Streams are not supported!'));
      return callback();
    }

    if (file.isBuffer()) {
      try {
        // terser option
        var option = _objectSpread({}, defaultOption);

        if (file.sourceMap) {
          option.sourceMap.filename = file.sourceMap.file;
        } // 配置需要兼容


        var str = file.contents.toString('utf8');
        var build =
        /* string | Object */
        {};

        if ('sourceMap' in file && 'file' in file.sourceMap) {
          build[file.sourceMap.file] = str;
        } else {
          build = str;
        } // 压缩代码（terser5是异步，terser4是同步）


        var resultPromise = (minify !== null && minify !== void 0 ? minify : _terser.default.minify)(build, option); // 编译函数

        var setContents = function setContents(result) {
          // 输出报错信息
          if ('error' in result) {
            throw new Error(result.error.message);
          } // Buffer


          file.contents = 'from' in Buffer ? Buffer.from(result.code) : new Buffer(result.code); // 输出source-map

          if (file.sourceMap && result.map) {
            (0, _vinylSourcemapsApply.default)(file, result.map);
          }

          _this.push(file);
        };

        if (isPromise()(resultPromise)) {
          return resultPromise.then(function (result) {
            setContents(result);
            return Promise.resolve(callback());
          }).catch(function (err) {
            _this.emit('error', new _pluginError.default(PLUGIN_NAME, err));

            return callback();
          });
        } else {
          setContents(resultPromise);
          return callback();
        }
      } catch (err) {
        this.emit('error', new _pluginError.default(PLUGIN_NAME, err));
        return callback();
      }
    }
  });

  return stream;
}

module.exports = gulpTerser;