/*!
 *  v
 * 
 * (c) 2024 Theme author *  License
 * https://github.com/stop14/stop14-themesystem-legacy] */

/*!
 * jQuery throttle / debounce - v1.1 - 3/7/2010
 * http://benalman.com/projects/jquery-throttle-debounce-plugin/
 * 
 * Copyright (c) 2010 "Cowboy" Ben Alman
 * Dual licensed under the MIT and GPL licenses.
 * http://benalman.com/about/license/
 */

// Script: jQuery throttle / debounce: Sometimes, less is more!
//
// *Version: 1.1, Last updated: 3/7/2010*
// 
// Project Home - http://benalman.com/projects/jquery-throttle-debounce-plugin/
// GitHub       - http://github.com/cowboy/jquery-throttle-debounce/
// Source       - http://github.com/cowboy/jquery-throttle-debounce/raw/master/jquery.ba-throttle-debounce.js
// (Minified)   - http://github.com/cowboy/jquery-throttle-debounce/raw/master/jquery.ba-throttle-debounce.min.js (0.7kb)
// 
// About: License
// 
// Copyright (c) 2010 "Cowboy" Ben Alman,
// Dual licensed under the MIT and GPL licenses.
// http://benalman.com/about/license/
// 
// About: Examples
// 
// These working examples, complete with fully commented code, illustrate a few
// ways in which this plugin can be used.
// 
// Throttle - http://benalman.com/code/projects/jquery-throttle-debounce/examples/throttle/
// Debounce - http://benalman.com/code/projects/jquery-throttle-debounce/examples/debounce/
// 
// About: Support and Testing
// 
// Information about what version or versions of jQuery this plugin has been
// tested with, what browsers it has been tested in, and where the unit tests
// reside (so you can test it yourself).
// 
// jQuery Versions - none, 1.3.2, 1.4.2
// Browsers Tested - Internet Explorer 6-8, Firefox 2-3.6, Safari 3-4, Chrome 4-5, Opera 9.6-10.1.
// Unit Tests      - http://benalman.com/code/projects/jquery-throttle-debounce/unit/
// 
// About: Release History
// 
// 1.1 - (3/7/2010) Fixed a bug in <jQuery.throttle> where trailing callbacks
//       executed later than they should. Reworked a fair amount of internal
//       logic as well.
// 1.0 - (3/6/2010) Initial release as a stand-alone project. Migrated over
//       from jquery-misc repo v0.4 to jquery-throttle repo v1.0, added the
//       no_trailing throttle parameter and debounce functionality.
// 
// Topic: Note for non-jQuery users
// 
// jQuery isn't actually required for this plugin, because nothing internal
// uses any jQuery methods or properties. jQuery is just used as a namespace
// under which these methods can exist.
// 
// Since jQuery isn't actually required for this plugin, if jQuery doesn't exist
// when this plugin is loaded, the method described below will be created in
// the `Cowboy` namespace. Usage will be exactly the same, but instead of
// $.method() or jQuery.method(), you'll need to use Cowboy.method().

(function(window,undefined){
  '$:nomunge'; // Used by YUI compressor.
  
  // Since jQuery really isn't required for this plugin, use `jQuery` as the
  // namespace only if it already exists, otherwise use the `Cowboy` namespace,
  // creating it if necessary.
  var $ = jQuery || window.jQuery || window.Cowboy || ( window.Cowboy = {} ),
    
    // Internal method reference.
    jq_throttle;
  
  // Method: jQuery.throttle
  // 
  // Throttle execution of a function. Especially useful for rate limiting
  // execution of handlers on events like resize and scroll. If you want to
  // rate-limit execution of a function to a single time, see the
  // <jQuery.debounce> method.
  // 
  // In this visualization, | is a throttled-function call and X is the actual
  // callback execution:
  // 
  // > Throttled with `no_trailing` specified as false or unspecified:
  // > ||||||||||||||||||||||||| (pause) |||||||||||||||||||||||||
  // > X    X    X    X    X    X        X    X    X    X    X    X
  // > 
  // > Throttled with `no_trailing` specified as true:
  // > ||||||||||||||||||||||||| (pause) |||||||||||||||||||||||||
  // > X    X    X    X    X             X    X    X    X    X
  // 
  // Usage:
  // 
  // > var throttled = jQuery.throttle( delay, [ no_trailing, ] callback );
  // > 
  // > jQuery('selector').bind( 'someevent', throttled );
  // > jQuery('selector').unbind( 'someevent', throttled );
  // 
  // This also works in jQuery 1.4+:
  // 
  // > jQuery('selector').bind( 'someevent', jQuery.throttle( delay, [ no_trailing, ] callback ) );
  // > jQuery('selector').unbind( 'someevent', callback );
  // 
  // Arguments:
  // 
  //  delay - (Number) A zero-or-greater delay in milliseconds. For event
  //    callbacks, values around 100 or 250 (or even higher) are most useful.
  //  no_trailing - (Boolean) Optional, defaults to false. If no_trailing is
  //    true, callback will only execute every `delay` milliseconds while the
  //    throttled-function is being called. If no_trailing is false or
  //    unspecified, callback will be executed one final time after the last
  //    throttled-function call. (After the throttled-function has not been
  //    called for `delay` milliseconds, the internal counter is reset)
  //  callback - (Function) A function to be executed after delay milliseconds.
  //    The `this` context and all arguments are passed through, as-is, to
  //    `callback` when the throttled-function is executed.
  // 
  // Returns:
  // 
  //  (Function) A new, throttled, function.
  
  $.throttle = jq_throttle = function( delay, no_trailing, callback, debounce_mode ) {
    // After wrapper has stopped being called, this timeout ensures that
    // `callback` is executed at the proper times in `throttle` and `end`
    // debounce modes.
    var timeout_id,
      
      // Keep track of the last time `callback` was executed.
      last_exec = 0;
    
    // `no_trailing` defaults to falsy.
    if ( typeof no_trailing !== 'boolean' ) {
      debounce_mode = callback;
      callback = no_trailing;
      no_trailing = undefined;
    }
    
    // The `wrapper` function encapsulates all of the throttling / debouncing
    // functionality and when executed will limit the rate at which `callback`
    // is executed.
    function wrapper() {
      var that = this,
        elapsed = +new Date() - last_exec,
        args = arguments;
      
      // Execute `callback` and update the `last_exec` timestamp.
      function exec() {
        last_exec = +new Date();
        callback.apply( that, args );
      };
      
      // If `debounce_mode` is true (at_begin) this is used to clear the flag
      // to allow future `callback` executions.
      function clear() {
        timeout_id = undefined;
      };
      
      if ( debounce_mode && !timeout_id ) {
        // Since `wrapper` is being called for the first time and
        // `debounce_mode` is true (at_begin), execute `callback`.
        exec();
      }
      
      // Clear any existing timeout.
      timeout_id && clearTimeout( timeout_id );
      
      if ( debounce_mode === undefined && elapsed > delay ) {
        // In throttle mode, if `delay` time has been exceeded, execute
        // `callback`.
        exec();
        
      } else if ( no_trailing !== true ) {
        // In trailing throttle mode, since `delay` time has not been
        // exceeded, schedule `callback` to execute `delay` ms after most
        // recent execution.
        // 
        // If `debounce_mode` is true (at_begin), schedule `clear` to execute
        // after `delay` ms.
        // 
        // If `debounce_mode` is false (at end), schedule `callback` to
        // execute after `delay` ms.
        timeout_id = setTimeout( debounce_mode ? clear : exec, debounce_mode === undefined ? delay - elapsed : delay );
      }
    };
    
    // Set the guid of `wrapper` function to the same of original callback, so
    // it can be removed in jQuery 1.4+ .unbind or .die by using the original
    // callback as a reference.
    if ( $.guid ) {
      wrapper.guid = callback.guid = callback.guid || $.guid++;
    }
    
    // Return the wrapper function.
    return wrapper;
  };
  
  // Method: jQuery.debounce
  // 
  // Debounce execution of a function. Debouncing, unlike throttling,
  // guarantees that a function is only executed a single time, either at the
  // very beginning of a series of calls, or at the very end. If you want to
  // simply rate-limit execution of a function, see the <jQuery.throttle>
  // method.
  // 
  // In this visualization, | is a debounced-function call and X is the actual
  // callback execution:
  // 
  // > Debounced with `at_begin` specified as false or unspecified:
  // > ||||||||||||||||||||||||| (pause) |||||||||||||||||||||||||
  // >                          X                                 X
  // > 
  // > Debounced with `at_begin` specified as true:
  // > ||||||||||||||||||||||||| (pause) |||||||||||||||||||||||||
  // > X                                 X
  // 
  // Usage:
  // 
  // > var debounced = jQuery.debounce( delay, [ at_begin, ] callback );
  // > 
  // > jQuery('selector').bind( 'someevent', debounced );
  // > jQuery('selector').unbind( 'someevent', debounced );
  // 
  // This also works in jQuery 1.4+:
  // 
  // > jQuery('selector').bind( 'someevent', jQuery.debounce( delay, [ at_begin, ] callback ) );
  // > jQuery('selector').unbind( 'someevent', callback );
  // 
  // Arguments:
  // 
  //  delay - (Number) A zero-or-greater delay in milliseconds. For event
  //    callbacks, values around 100 or 250 (or even higher) are most useful.
  //  at_begin - (Boolean) Optional, defaults to false. If at_begin is false or
  //    unspecified, callback will only be executed `delay` milliseconds after
  //    the last debounced-function call. If at_begin is true, callback will be
  //    executed only at the first debounced-function call. (After the
  //    throttled-function has not been called for `delay` milliseconds, the
  //    internal counter is reset)
  //  callback - (Function) A function to be executed after delay milliseconds.
  //    The `this` context and all arguments are passed through, as-is, to
  //    `callback` when the debounced-function is executed.
  // 
  // Returns:  
  
  // 
  //  (Function) A new, debounced, function.
  
  $.debounce = function( delay, at_begin, callback ) {
    return callback === undefined
      ? jq_throttle( delay, at_begin, false )
      : jq_throttle( delay, callback, at_begin !== false );
  };
  
})(this);
// if other scripts are available.

(function jq ($) {

  $(document).ready(function dr() {

      const activeArea = $('main > aside');
      const quotations = $('#quotations');
      const slides = quotations.children();
      quotations.find(':first-child').addClass('current');
      setInterval(_rotateSlides,window.animation.slideTransition);

      // Create pagination

      var pagination = $("<ul>").addClass('pagination');

      // Stop transition when user hovers over the active area

      activeArea.bind('mouseenter',function() {
        quotations.addClass('paused');
      });

      activeArea.bind('mouseleave',function() {
        quotations.removeClass('paused');
      });

      // Track height of slides
      var containerHeight = 0;

      slides.each((i,o) => {
        // Create markers for each page
        $(o).attr('data-index',i);
        let quoteNumber = i + 1;
        let marker = $('<span>').addClass('screen-reader-only').text("View quotation " + quoteNumber);
        let page = $('<li>').attr('data-index',i).append(marker);

        _updateContainerHeight()

        // Transition to slide when user clicks pagination marker

        page.on('click',function transitionPage() {
          var pageIndex =  $(this).attr('data-index');
          quotations.children('.current').removeClass('current');
          quotations.find('[data-index="' +  pageIndex + '"]').addClass('current');
          _updateMarker(pageIndex);
        });

        pagination.append(page);
      });

      pagination.find('[data-index="0"]').addClass('active');

      // Add pagination
      quotations.after(pagination);

      // Set height to tallest slide

      function _updateContainerHeight() {
        slides.each((i,o) => {
          // Update containerHeight if slide is taller. This works because the slide is suppressed using opacity rather than display: none (which would return 0 as a height)
          let slideHeight = $(o).innerHeight();
          containerHeight = slideHeight > containerHeight ? slideHeight : containerHeight;
          quotations.height(containerHeight);
        });
      }

      // Update on resize

      window.addEventListener("resize",jQuery.debounce(250,_updateContainerHeight));

      // Updates the pagination markers

      function _updateMarker(pageIndex) {
        pagination.children('.active').removeClass('active');
        pagination.children('[data-index="' + pageIndex + '"]').addClass('active');
      }

    // Rotate slides on an interval

      function _rotateSlides() {

        const paused = quotations.hasClass('paused') ? true : false;

        if (paused !== true) {
          var curSlide = quotations.find('.current');
          curSlide.removeClass('current');
          nextSlide = curSlide.next().length > 0 ? curSlide.next() : quotations.find(':first-child');
          nextSlide.addClass('current');

          // Update marker
          _updateMarker(nextSlide.attr("data-index"));
        }
      };

        /*
        var curIndex = quotations.index('.current') + 1
        var newIndex = curIndex > slides.length ? 0 : curIndex;
        var nthChild = newIndex + 1;
        console.log("New Interval");
        console.log(curIndex);
        quotations.find('.current').removeClass('current');
        quotations.find(":nth-child(" + nthChild + ")").addClass('current');
         */



      /*
      $(this).slick({
        "fade": true,
        "arrows": false,
        "dots": true,
        "autoplay": true,
        "slidesToShow": 1,
        "slidesToScroll": 1
      });
      */

  });

}(jQuery));

(function($) {
  $(document).ready(function() {
    // Select all links with hashes

    $('a[href*="#"]')
      // Remove links that don't actually link to anything
      .not('[href="#"]')
      .not('[href="#0"]')
      .click(function(event) {
        // On-page links
        if ( location.pathname.replace(/^\//, '') == this.pathname.replace(/^\//, '') && location.hostname == this.hostname ) {
          // Figure out element to scroll to
          var target = $(this.hash);
          target = target.length ? target : $('[name=' + this.hash.slice(1) + ']');
          // Does a scroll target exist?
          if (target.length) {
            // Only prevent default if animation is actually gonna happen
            event.preventDefault();
            $('html, body').animate({
              scrollTop: target.offset().top
            }, 1000, function() {
              // Callback after animation
              // Must change focus!
              var $target = $(target);
              $target.focus();
              if ($target.is(":focus")) { // Checking if the target was focused
                return false;
              } else {
                $target.attr('tabindex','-1'); // Adding tabindex for elements not focusable
                $target.focus(); // Set focus again
              }
            });
          }
        }
      });
  });
})(jQuery);

$(document).ready(function() {


  // For fixed height designs give the body class a mode='fixed-height' attribute OR set the second term here to true

  const smoothScrollActive = $('body').attr('mode') === 'fixed-height' || false;
  const intro = document.getElementById("introduction");

  if (typeof intro === "object" && intro !== null) {
    if (smoothScrollActive) {
      setIntroUI();
    } else {
      function hideIntroUI() {
        $('#introduction-ui-top, #introduction-ui-bottom').hide();
        $(intro).removeClass('scrollable-content');
      }

      hideIntroUI();

    }
  }

});




function setIntroUI() {

  let intro = document.getElementById("introduction"),
   down_btn = $("#down_btn"),
   up_btn = $("#up_btn");

  if (typeof intro === "object" && intro !== null) {

    $(intro).css("overflow-y", "scroll");
    let frame = intro.getBoundingClientRect(),
     fpframe = intro.firstElementChild.getBoundingClientRect(),
     lpframe = intro.lastElementChild.getBoundingClientRect();


    //if (lpframe.bottom < frame.bottom) {
      // $(intro).height(lpframe.bottom - frame.top);
    // }

    up_btn.hide();
    down_btn.hide();

    $(intro)
      .off("scroll")
      .on("scroll", function() {

        fpframe = intro.firstElementChild.getBoundingClientRect();
        lpframe = intro.lastElementChild.getBoundingClientRect();

        if (lpframe.bottom >= frame.bottom) {

          down_btn.fadeIn(200);
          $(intro).addClass('down');

        } else {

          down_btn.fadeOut(200);
          $(intro).removeClass('down');

        }

        if (frame.top > fpframe.top) {
          up_btn.fadeIn(200);
          $(intro).addClass('up');

        } else {
          up_btn.fadeOut(200);
          $(intro).removeClass('up');
        }

      });

    // Perform initial settings.

    $(intro).trigger("scroll");

    down_btn
      .off("click mouseenter mouseleave")
      .on("click", function() {

        $(intro).animate({
          "scrollTop": intro.scrollTop + frame.height
        });

})
      .on("mouseenter", function() {

        let img = $(this).find("img");
        if (img.length > 0) {

          img.attr("src", img.attr("src").replace("down_button_up", "down_button_over"));

}

})
      .on("mouseleave", function() {

        let img = $(this).find("img");
        if (img.length > 0) {

          img.attr("src", img.attr("src").replace("down_button_over", "down_button_up"));

}

});

    up_btn
      .off("click mouseenter mouseleave")
      .on("click", function() {

        $(intro).animate({
          "scrollTop": intro.scrollTop - frame.height
        });

})
      .on("mouseenter", function() {

        let img = $(this).find("img");
        if (img.length > 0) {

          img.attr("src", img.attr("src").replace("up_button_up", "up_button_over"));

}

})
      .on("mouseleave", function() {

        let img = $(this).find("img");
        if (img.length > 0) {

          img.attr("src", img.attr("src").replace("up_button_over", "up_button_up"));

}

});

}

}

window.addEventListener("resize", jQuery.debounce(250,setIntroUI));


/**
 *  @file video.js
 *
 *  Handles .field_media_video_file videos.
 *
 *  Attaches play and pause listeners to alternative controls.
 *  Provides a timer which checks the play state of the video, and adds appropriate classes.
 *  This allows the alternative controls to handled via SASS. It also allows the alternative controls to be sensistive
 *  when the play state is changed by the standard controls.
 *
 */


// Select HTML5 video
const videos = document.querySelectorAll(".field_media_video_file");


for (i=0; i < videos.length; i++) {
  const container = videos[i];
  const video = container.querySelector('video');
  
  if (video !== null) {
    const controls = video.parentElement.querySelector('.control-container');
  
    if (controls !== null && video.hasAttribute('controls') && video.getAttribute('controls') === 'controls') {
        container.classList.add('controls');
        const playBtn = controls.parentElement.querySelector(".play");
        const pauseBtn = controls.querySelector(".pause");
    
      // see https://developer.chrome.com/blog/autoplay/
      if (video.hasAttribute("autoplay") && video.hasAttribute('muted')) {
        controls.classList.remove('paused');
        controls.classList.add('playing');
      }
      // pause or play the video
      const play = (e) => {
        // Condition when to play a video
        if (video.paused) {
          if (controls.classList.contains('paused')) { // Prevents play/pause race conditions that throw console errors.
            video.play()
          }
        } else {
          if (controls.classList.contains('playing')) {
            video.pause();
          }
        }
      }
      
      // Detects the current playstate
      
      function isPlaying(player, controlElement) {
        if (player.currentTime > 0 && !player.paused && !player.ended
          && player.readyState > player.HAVE_CURRENT_DATA) {
          controlElement.classList.remove('paused');
          controlElement.classList.add('playing');
        } else {
          controlElement.classList.remove('playing');
          controlElement.classList.add('paused');
        }
      }
      
      // Audit the video player’s play state on a timer
      
      var playerState = setInterval(isPlaying, 100, video, controls);
      
      // Attach play/pause as listeners
      
      playBtn.addEventListener('click', play);
      pauseBtn.addEventListener('click', play);
      
      if ('ontouchstart' in window) {
        playBtn.addEventListener('ontouchstart', play);
        pauseBtn.addEventListener('ontouchstart', play);
      }
    }
  }
}
/**
// set the pause button to display:none by default
document.querySelector(".fa-pause").style.display = "none"
// update the progress bar
video.addEventListener("timeupdate", () => {
  let curr = (video.currentTime / video.duration) * 100
  if(video.ended){
    document.querySelector(".fa-play").style.display = "block"
    document.querySelector(".fa-pause").style.display = "none"
  }
  document.querySelector('.inner').style.width = `${curr}%`
})

// trigger fullscreen
const fullScreen = (e) => {
  e.preventDefault()
  video.requestFullscreen()
}
// download the video
const download = (e) => {
  e.preventDefault()
  let a = document.createElement('a')
  a.href = video.src
  a.target = "_blank"
  a.download = ""
  document.body.appendChild(a)
  a.click()
  document.body.removeChild(a)
}
// rewind the current time
const rewind = (e) => {
  video.currentTime = video.currentTime - ((video.duration/100) * 5)
}
// forward the current time
const forward = (e) => {
  video.currentTime = video.currentTime + ((video.duration/100) * 5)
}
**/
